<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Receipt - <?php echo e($order->order_number); ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 0.75rem; padding: 10px; }
        .text-center { text-align: center; }
        .font-bold { font-weight: bold; }
        .text-sm { font-size: 0.875rem; }
        .text-xs { font-size: 0.75rem; }
        .my-2 { margin: 0.5rem 0; }
        hr { border: none; border-top: 1px solid #ccc; margin: 0.5rem 0; }
        .flex { display: flex; }
        .justify-between { justify-content: space-between; }
        .invoice-table { width: 100%; border-collapse: collapse; margin-top: 0.5rem; }
        .invoice-table th, .invoice-table td { border: 1px solid #ccc; padding: 4px; text-align: left; }
    </style>
</head>
<body>
    <!-- Receipt Header -->
    <div class="text-center font-bold">QUICK MART LTD.</div>
    <div class="text-center text-sm">KITALE BRANCH</div>
    <div class="text-center text-xs">
        P.O. Box 3241-40200, Kitale Market<br/>
        Tel: 0110003003, www.quickmart.co.ke
    </div>
    <hr class="my-2" />
    <div class="text-center font-bold my-2">CASH SALE</div>
    <hr class="my-2" />

    <!-- Order Details -->
    <div class="text-xs font-bold">Order Details:</div>
    <div class="flex justify-between text-xs">
        <span>Date:</span>
        <span><?php echo e(\Carbon\Carbon::parse($order->created_at)->format('d/m/Y')); ?></span>
    </div>
    <div class="flex justify-between text-xs">
        <span>Time:</span>
        <span><?php echo e(\Carbon\Carbon::parse($order->created_at)->format('H:i:s')); ?></span>
    </div>
    <div class="flex justify-between text-xs">
        <span>Receipt No:</span>
        <span><?php echo e($order->order_number); ?></span>
    </div>
    <div class="flex justify-between text-xs">
        <span>Cashier:</span>
        <span><?php echo e($order->cashier); ?></span>
    </div>
    <?php
        $totalQty = $order->orderItems->sum('quantity');
    ?>
    <div class="flex justify-between text-xs">
        <span>Total Qty:</span>
        <span><?php echo e($totalQty); ?></span>
    </div>
    <hr class="my-2" />

    <!-- Items List -->
    <div class="text-xs font-bold">Items:</div>
    <?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="flex justify-between text-xs">
            <span><?php echo e(optional($item->product)->name ?? 'Unknown Product'); ?> (x<?php echo e($item->quantity); ?>)</span>
            <span>Ksh. <?php echo e(number_format($item->total, 2)); ?></span>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <hr class="my-2" />

    <!-- Totals -->
    <div class="flex justify-between text-xs font-bold">
        <span>Total Amount:</span>
        <span>Ksh. <?php echo e(number_format($order->total_amount, 2)); ?></span>
    </div>
    <div class="flex justify-between text-xs">
        <span>Cash Paid:</span>
        <span>Ksh. <?php echo e(number_format($order->payment_details['cashPaid'] ?? $order->total_amount, 2)); ?></span>
    </div>
    <div class="flex justify-between text-xs">
        <span>Change:</span>
        <span>Ksh. <?php echo e(number_format($order->payment_details['change'] ?? 0, 2)); ?></span>
    </div>
    <hr class="my-2" />

    <!-- M-PESA Details (only if payment method is MPesa) -->
    <?php if($order->payment_method === 'mpesa' && isset($order->payment_details['mpesa'])): ?>
        <div class="text-xs font-bold">M-PESA DETAILS:</div>
        <div class="text-xs">Name: <?php echo e($order->payment_details['mpesa']['name'] ?? ''); ?></div>
        <div class="text-xs">Mobile: <?php echo e($order->payment_details['mpesa']['mobile'] ?? ''); ?></div>
        <div class="text-xs">MPESA Type: <?php echo e($order->payment_details['mpesa']['type'] ?? ''); ?></div>
        <div class="text-xs">Reference ID: <?php echo e($order->payment_details['mpesa']['refId'] ?? ''); ?></div>
        <div class="text-xs">Org ID: <?php echo e($order->payment_details['mpesa']['orgId'] ?? ''); ?></div>
        <div class="text-xs">Amount: Ksh. <?php echo e(number_format($order->payment_details['mpesa']['amount'] ?? 0, 2)); ?></div>
        <hr class="my-2" />
    <?php endif; ?>

    <!-- Control Unit Info (if available) -->
    <?php if(isset($order->receipt_path)): ?>
        <div class="text-xs font-bold">Control Unit Info:</div>
        <div class="text-xs">CU Serial No: <?php echo e($order->control_unit_serial ?? 'N/A'); ?></div>
        <div class="text-xs">Invoice No: <?php echo e($order->control_unit_invoice ?? 'N/A'); ?></div>
        <div class="text-xs">Receipt No: <?php echo e($order->control_unit_receipt ?? 'N/A'); ?></div>
        <hr class="my-2" />
    <?php endif; ?>

    <!-- QR Code (if available) -->
    <?php if(isset($order->qr_code)): ?>
        <div class="text-center">
            <img src="<?php echo e($order->qr_code); ?>" alt="QR Code" style="max-width: 100px; margin: 0 auto;">
        </div>
        <hr class="my-2" />
    <?php endif; ?>

    <!-- Rewarded Discounts (if any) -->
    <?php if(isset($order->payment_details['discounts']) && count($order->payment_details['discounts']) > 0): ?>
        <div class="text-center font-bold">Rewarded Discounts</div>
        <?php $__currentLoopData = $order->payment_details['discounts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex justify-between text-xs">
                <span><?php echo e($disc['item']); ?></span>
                <span>Ksh. -<?php echo e(number_format($disc['amount'], 2)); ?></span>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div class="flex justify-between text-xs font-bold">
            <span>Total Discount</span>
            <span>Ksh. -<?php echo e(number_format($order->payment_details['totalDiscount'] ?? 0, 2)); ?></span>
        </div>
        <hr class="my-2" />
    <?php endif; ?>

    <!-- Footer -->
    <div class="text-center">
        <p>Thank You For Shopping With Us. Please Come Again</p>
    </div>
</body>
</html>
<?php /**PATH /Users/ligala/Desktop/DEVOPs/PHP/Laravel/pos-api/resources/views/orders/receipt.blade.php ENDPATH**/ ?>