<?php

use App\Http\Controllers\AllowanceController;
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\VariantController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\ShiftController;

// Authentication Routes
Route::prefix('auth')->group(function () {
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/refresh', [AuthController::class, 'refreshToken']);

    // Logout Route
    Route::middleware('auth:sanctum')->post('/logout', [AuthController::class, 'logout']);
});

// Debugging routes
Route::middleware(['auth:sanctum', 'check.role.permission:manager'])->group(function () {
    Route::post('/manage-users', [ProductController::class, 'index']);
});

Route::middleware(['auth:sanctum', 'check.role.permission:cashier'])->group(function () {
    Route::get('/view-inventory', [ProductController::class, 'index']);
});


// 🔹 **Roles Management**
Route::middleware(['auth:sanctum', 'check.role.permission:superadmin,manage_roles'])->prefix('roles')->group(function () {
    Route::get('/', [RoleController::class, 'index']);
    Route::post('/', [RoleController::class, 'store']);
    Route::get('/{id}', [RoleController::class, 'show']);
    Route::put('/{id}', [RoleController::class, 'update']);
    Route::delete('/{id}', [RoleController::class, 'destroy']);
});

// 🔹 **Protected Routes for Authenticated Users**
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    Route::prefix('employees')->group(function () {
        Route::get('/', [EmployeeController::class, 'index']);
        Route::post('/', [EmployeeController::class, 'store']);
        Route::get('/{id}', [EmployeeController::class, 'show']);
        Route::put('/{id}', [EmployeeController::class, 'update']);
        Route::delete('/{id}', [EmployeeController::class, 'destroy']);
    });
    // 🔹 **Subscription Routes**
    Route::prefix('subscriptions')->group(function () {
        Route::get('/', [SubscriptionController::class, 'index']);
        Route::post('/', [SubscriptionController::class, 'store']);
        Route::get('/{id}', [SubscriptionController::class, 'show']);
        Route::put('/{id}', [SubscriptionController::class, 'update']);
        Route::delete('/{id}', [SubscriptionController::class, 'destroy']);
    });

    // 🔹 **Category Management**
    Route::prefix('categories')->group(function () {
        Route::get('/', [CategoryController::class, 'index']);
        Route::post('/', [CategoryController::class, 'store']);
        Route::get('/{id}', [CategoryController::class, 'show']);
        Route::put('/{id}', [CategoryController::class, 'update']);
        Route::delete('/{id}', [CategoryController::class, 'destroy']);
    });

    // 🔹 **Order Management**
    Route::prefix('orders')->group(function () {
        Route::get('/', [OrderController::class, 'index']); // List all orders
        Route::post('/', [OrderController::class, 'store']); // Create a new order
        Route::get('/{id}', [OrderController::class, 'show']); // View a specific order
        Route::put('/{id}', [OrderController::class, 'update']); // Update an order
        Route::delete('/{id}', [OrderController::class, 'destroy']); // Delete an order
    });

    // 🔹 **Product Management Routes**
Route::prefix('products')->group(function () {
    Route::get('/', [ProductController::class, 'index']);
    Route::post('/', [ProductController::class, 'store']);
    Route::post('/batch', [ProductController::class, 'batchStore']);
    Route::get('/expiring', [ProductController::class, 'expiringProducts']); // Expiring Products
    Route::get('/{id}', [ProductController::class, 'show']); // This after
    Route::put('/{id}', [ProductController::class, 'update']);
    Route::delete('/{id}', [ProductController::class, 'destroy']);
    Route::post('/{id}/restore', [ProductController::class, 'restore']);
    Route::get('/category/{id}', [ProductController::class, 'filterByCategory']);
    Route::get('/expiring', [ProductController::class, 'expiringProducts']);
});

// 🔹 **Brand Management Routes**
Route::prefix('brands')->group(function () {
    Route::get('/', [BrandController::class, 'index']); // Get all brands
    Route::post('/', [BrandController::class, 'store']); // Create a new brand
    Route::get('/{id}', [BrandController::class, 'show']); // View a single brand
    Route::post('/{id}', [BrandController::class, 'update']); // Update a brand
    Route::delete('/{id}', [BrandController::class, 'destroy']); // Delete a brand
});

// 🔹 **Unit Management Routes**
Route::prefix('units')->group(function () {
    Route::get('/', [UnitController::class, 'index']); // Get all units
    Route::post('/', [UnitController::class, 'store']); // Create a new unit
    Route::get('/{id}', [UnitController::class, 'show']); // View a single unit
    Route::put('/{id}', [UnitController::class, 'update']); // Update a unit
    Route::delete('/{id}', [UnitController::class, 'destroy']); // Delete a unit
});

// 🔹 **Variant Management Routes**
Route::prefix('variants')->group(function () {
    Route::get('/', [VariantController::class, 'index']); // Get all variants
    Route::post('/', [VariantController::class, 'store']); // Create a new variant
    Route::get('/{product_id}', [VariantController::class, 'show']); // Get variants for a product
    Route::put('/{id}', [VariantController::class, 'update']); // Update a variant
    Route::delete('/{id}', [VariantController::class, 'destroy']); // Delete a variant
});

// 🔹 **Human Resource Management**
Route::prefix('hrm')->group(function () {
    // Employees
    Route::get('/employees/', [EmployeeController::class, 'index']); // Get all employees
    Route::post('/employees/', [EmployeeController::class, 'store']); // Create a new Employee

    //Departments
    Route::get('/departments',[DepartmentController::class, 'index']); //Get all Departments
    Route::get('/departments/{id}',[DepartmentController::class, 'show']); //Get a Specific Department
    Route::post('/departments/',[DepartmentController::class, 'store']); //Create a New Department
    Route::put('/departments/{id}',[DepartmentController::class, 'update']); //Edit a  Department
    Route::delete('/departments/{id}',[DepartmentController::class, 'destroy']); //Delete a Department

    //Designations
    Route::get('/designations',[DesignationController::class, 'index']); //Get all Designations
    Route::post('/designations/',[DesignationController::class, 'store']); //Create a New Designation
    Route::put('/designations/{id}',[DesignationController::class, 'update']); //Edit a  Designation
    Route::delete('/designations/{id}',[DesignationController::class, 'destroy']); //Delete a Designation

    //Shifts
    Route::get('/shifts', [ShiftController::class, 'index']); //Get all Shifts
    Route::post('/shifts/',[ShiftController::class, 'store']); //Create a New Shift
    Route::put('/shifts/{id}',[ShiftController::class, 'update']); //Edit a  Shift
    Route::delete('/shifts/{id}',[ShiftController::class, 'destroy']); //Delete a Shift

    //Allowances
    Route::get( "/allowances", [AllowanceController::class, 'index']); //Get All Allowances
    Route::get('/allowances/{id}', [AllowanceController::class, 'show']); //Get a Specific Allowance;
    Route::post('/allowances', [AllowanceController::class, 'store']); //Create a New Allowance
    Route::put('/allowances/{id}', [AllowanceController::class, 'update']); //Edit an Allowance
    Route::delete('/allowances/{id}', [AllowanceController::class, 'destroy']); //Delete a Specific Allowance
});
});
