<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;

class RoleSeeder extends Seeder
{
    public function run()
    {
        $roles = [
            [
                'name' => 'superadmin',
                'permissions' => [
                    'manage_organizations', 'manage_users', 'manage_roles', 'view_reports',
                ],
            ],
            [
                'name' => 'owner',
                'permissions' => [
                    'manage_users', 'manage_inventory', 'view_reports',
                ],
            ],
            [
                'name' => 'manager',
                'permissions' => [
                    'manage_users', 'manage_inventory', 'view_reports',
                ],
            ],
            [
                'name' => 'supervisor',
                'permissions' => [
                    'view_inventory', 'process_orders',
                ],
            ],
            [
                'name' => 'cashier',
                'permissions' => [
                    'process_orders', 'view_inventory',
                ],
            ],
        ];

        foreach ($roles as $role) {
            Role::updateOrCreate(['name' => $role['name']], [
                'permissions' => $role['permissions'],
            ]);
        }
    }
}
