<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DefaultCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Insert default category
        DB::table('categories')->insertOrIgnore([
            'category_number' => '00',
            'name' => 'Test',
            'description' => 'Default category for unclassified products.',
        ]);

        // Fetch the default category ID
        $defaultCategoryId = DB::table('categories')->where('name', 'Test')->value('id');

        // Update products with null category_id
        DB::table('products')->whereNull('category_id')->update(['category_id' => $defaultCategoryId]);
    }
}
