<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Organization;
use App\Models\User;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        // ✅ Seed roles (Ensures they exist, prevents duplicates)
        Role::firstOrCreate(['name' => 'Cashier']);
        Role::firstOrCreate(['name' => 'Supervisor']);
        Role::firstOrCreate(['name' => 'Manager']);

        // ✅ Seed organization (Ensures it exists, prevents duplicates)
        Organization::updateOrInsert(
            ['id' => 1], // ✅ Ensure unique primary key
            [
                'name' => 'Default Organization',
                'kra_pin' => 'A12345678B',
                'nssf_number' => 'NSSF1234',
                'nhif_number' => 'NHIF1234',
                'house_levy_number' => 'LEVY1234'
            ]
        );

        // ✅ Seed a user (Prevents duplicate users)
        User::firstOrCreate(
            ['email' => 'test@example.com'], // Ensure uniqueness
            [
                'name' => 'Test User',
                'password' => bcrypt('password'),
                'role_id' => 1, // Ensure this matches a seeded role ID
                'organization_id' => 1, // Ensure this matches a seeded organization ID
                'phone_number' => '0725611832',
            ]
        );
    }
}
