<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'category_number' => '01',
                'name' => 'Electronics',
                'description' => 'Devices and gadgets including mobile phones, laptops, and accessories.',
                'image' => null,
            ],
            [
                'category_number' => '02',
                'name' => 'Fashion',
                'description' => 'Clothing, shoes, and accessories for all genders.',
                'image' => null,
            ],
            [
                'category_number' => '03',
                'name' => 'Home Appliances',
                'description' => 'Essential appliances for the home such as refrigerators and washing machines.',
                'image' => null,
            ],
            [
                'category_number' => '04',
                'name' => 'Books',
                'description' => 'Educational, fictional, and non-fictional books.',
                'image' => null,
            ],
            [
                'category_number' => '05',
                'name' => 'Toys',
                'description' => 'Fun and educational toys for kids.',
                'image' => null,
            ],

            [
                'category_number' => '06',
                'name' => 'Home Furniture',
                'description' => 'Elegant and Stylish furniture.',
                'image' => null,
            ],
        ];

        foreach ($categories as $category) {
            DB::table('categories')->insert([
                'category_number' => $category['category_number'],
                'name' => $category['name'],
                'description' => $category['description'],
                'image' => $category['image'], // Can be updated later
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
