<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (!Schema::hasColumn('employees', 'marital_status')) {
                $table->string('marital_status')->nullable();
            }
            if (!Schema::hasColumn('employees', 'gender')) {
                $table->string('gender')->nullable();
            }
            if (!Schema::hasColumn('employees', 'national_id')) {
                $table->string('national_id')->nullable();
            }
            if (!Schema::hasColumn('employees', 'kra_pin')) {
                $table->string('kra_pin')->nullable();
            }
            if (!Schema::hasColumn('employees', 'shif_no')) {
                $table->string('shif_no')->nullable();
            }
            if (!Schema::hasColumn('employees', 'nssf_no')) {
                $table->string('nssf_no')->nullable();
            }
            if (!Schema::hasColumn('employees', 'bank_name')) {
                $table->string('bank_name')->nullable();
            }
            if (!Schema::hasColumn('employees', 'account_no')) {
                $table->string('account_no')->nullable();
            }
            if (!Schema::hasColumn('employees', 'salary')) {
                $table->decimal('salary', 10, 2)->nullable();
            }
            if (!Schema::hasColumn('employees', 'allowances')) {
                $table->json('allowances')->nullable();
            }
            if (!Schema::hasColumn('employees', 'deductions')) {
                $table->json('deductions')->nullable();
            }
            if (!Schema::hasColumn('employees', 'passport_image')) {
                $table->string('passport_image')->nullable();
            }
            if (!Schema::hasColumn('employees', 'department_id')) {
                $table->foreignId('department_id')->nullable()->constrained()->onDelete('cascade');
            }
            if (!Schema::hasColumn('employees', 'designation_id')) {
                $table->foreignId('designation_id')->nullable()->constrained()->onDelete('cascade');
            }
            if (!Schema::hasColumn('employees', 'shift_id')) {
                $table->foreignId('shift_id')->nullable()->constrained()->onDelete('cascade');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (Schema::hasColumn('employees', 'department_id')) {
                $table->dropForeign(['department_id']);
                $table->dropColumn('department_id');
            }
            if (Schema::hasColumn('employees', 'designation_id')) {
                $table->dropForeign(['designation_id']);
                $table->dropColumn('designation_id');
            }
            if (Schema::hasColumn('employees', 'shift_id')) {
                $table->dropForeign(['shift_id']);
                $table->dropColumn('shift_id');
            }
            $table->dropColumn([
                'marital_status',
                'gender',
                'national_id',
                'kra_pin',
                'shif_no',
                'nssf_no',
                'bank_name',
                'account_no',
                'salary',
                'allowances',
                'deductions',
                'passport_image'
            ]);
        });
    }
};
