<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('designations', function (Blueprint $table) {
            // Add the min_salary column if it does not exist.
            if (!Schema::hasColumn('designations', 'min_salary')) {
                $table->decimal('min_salary', 10, 2)->after('job_group');
            }

            // Add the max_salary column if it does not exist.
            if (!Schema::hasColumn('designations', 'max_salary')) {
                $table->decimal('max_salary', 10, 2)->after('min_salary');
            }

            // Add the benefits column as JSON if it does not exist.
            if (!Schema::hasColumn('designations', 'benefits')) {
                $table->json('benefits')->nullable()->after('max_salary');
            }

            // Add the deductions column as JSON if it does not exist.
            if (!Schema::hasColumn('designations', 'deductions')) {
                $table->json('deductions')->nullable()->after('benefits');
            }

            // Add the allowances column as JSON if it does not exist.
            if (!Schema::hasColumn('designations', 'allowances')) {
                $table->json('allowances')->nullable()->after('deductions');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('designations', function (Blueprint $table) {
            if (Schema::hasColumn('designations', 'allowances')) {
                $table->dropColumn('allowances');
            }
            if (Schema::hasColumn('designations', 'deductions')) {
                $table->dropColumn('deductions');
            }
            if (Schema::hasColumn('designations', 'benefits')) {
                $table->dropColumn('benefits');
            }
            if (Schema::hasColumn('designations', 'max_salary')) {
                $table->dropColumn('max_salary');
            }
            if (Schema::hasColumn('designations', 'min_salary')) {
                $table->dropColumn('min_salary');
            }
        });
    }
};
