<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        // Alter the existing employee_shift table.
        Schema::table('employee_shift', function (Blueprint $table) {
            // Add a column to store the date of the shift if not already present.
            if (!Schema::hasColumn('employee_shift', 'shift_date')) {
                $table->date('shift_date');
            }
            // Add columns for shift start and end times.
            if (!Schema::hasColumn('employee_shift', 'shift_start_time')) {
                $table->time('shift_start_time')->nullable();
            }
            if (!Schema::hasColumn('employee_shift', 'shift_end_time')) {
                $table->time('shift_end_time')->nullable();
            }
            // Add a unique index to prevent the same employee from being assigned to
            // the exact same shift timeframe more than once.
            $table->unique(['employee_id', 'shift_date', 'shift_start_time', 'shift_end_time'], 'unique_employee_shift');
        });
    }

    public function down()
    {
        Schema::table('employee_shift', function (Blueprint $table) {
            $table->dropUnique('unique_employee_shift');
            if (Schema::hasColumn('employee_shift', 'shift_start_time')) {
                $table->dropColumn('shift_start_time');
            }
            if (Schema::hasColumn('employee_shift', 'shift_end_time')) {
                $table->dropColumn('shift_end_time');
            }
            // Note: We do not drop shift_date if it was originally present.
        });
    }
};
