<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('employee_shift', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->foreignId('shift_id')->constrained()->onDelete('cascade');
            // Add a shift_date column to capture the date of the shift.
            $table->date('shift_date');
            $table->time('clock_in')->nullable();
            $table->time('clock_out')->nullable();
            $table->timestamps();

            // Ensure that each employee can only be assigned to one shift per shift_date.
            $table->unique(['employee_id', 'shift_date']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('employee_shift');
    }
};
