<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::table('employees', function (Blueprint $table) {
        $table->unsignedBigInteger('department_id')->after('role')->nullable();
        $table->string('designation')->after('department_id')->nullable();

        // Optionally add foreign key constraint
        $table->foreign('department_id')->references('id')->on('departments')->onDelete('set null');
    });
}

public function down()
{
    Schema::table('employees', function (Blueprint $table) {
        $table->dropForeign(['department_id']);
        $table->dropColumn(['department_id', 'designation']);
    });
}

};
