<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateProductsTableAddBrandAndUnit extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            // Check and add the brand_id column if it does not exist
            if (!Schema::hasColumn('products', 'brand_id')) {
                $table->unsignedBigInteger('brand_id')->nullable()->after('sub_category_id');
                $table->foreign('brand_id')->references('id')->on('brands')->onDelete('set null');
            }

            // Check and add the unit_id column if it does not exist
            if (!Schema::hasColumn('products', 'unit_id')) {
                $table->unsignedBigInteger('unit_id')->nullable()->after('brand_id');
                $table->foreign('unit_id')->references('id')->on('units')->onDelete('set null');
            }
        });
    }

    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            // Remove foreign key and drop the brand_id column if it exists
            if (Schema::hasColumn('products', 'brand_id')) {
                $table->dropForeign(['brand_id']);
                $table->dropColumn('brand_id');
            }

            // Remove foreign key and drop the unit_id column if it exists
            if (Schema::hasColumn('products', 'unit_id')) {
                $table->dropForeign(['unit_id']);
                $table->dropColumn('unit_id');
            }
        });
    }
}
