<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('variants', function (Blueprint $table) {
            // Remove product_id column since it's now many-to-many
            $table->dropForeign(['product_id']);
            $table->dropColumn('product_id');
        });
    }

    public function down()
    {
        Schema::table('variants', function (Blueprint $table) {
            // Revert by adding the product_id back (only if necessary)
            $table->foreignId('product_id')->nullable()->constrained()->onDelete('cascade');
        });
    }
};
