<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2)->default(0); // Price with two decimal places
            $table->unsignedInteger('quantity')->default(0); // Quantity in stock
            $table->string('manufacturer')->nullable();
            $table->string('supplier')->nullable();
            $table->string('product_code')->unique(); // Unique product code
            $table->string('sku')->unique(); // Stock Keeping Unit, unique
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
}
