<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Variant extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'value'
    ];

    // (Optional) Reverse relationship: one variant attribute can be used in many product variants
    public function productVariants()
    {
        return $this->hasMany(ProductVariant::class);
    }
}
