<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory;

    protected $fillable = [
        'name',
        'email',
        'password',
        'role_id',
        'organization_id',
        'phone_number',
        'refresh_token',
    ];

    protected $hidden = [
        'password',
        'remember_token',
        'refresh_token',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function organization()
    {
        return $this->belongsTo(Organization::class);
    }

    /**
     * Check if the user has a specific permission.
     *
     * @param string $permission
     * @return bool
     */
    public function hasPermission(string $permission): bool
    {
        // Check if the user has a role
        if (!$this->role || !isset($this->role->permissions)) {
            return false;
        }

        // Check if the permission exists in the user's role permissions
        return in_array($permission, $this->role->permissions, true);
    }
}
