<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'organization_id',
        'start_date',
        'end_date',
        'type', // e.g., monthly, bi-annual, yearly
        'status', // e.g., active, expired
    ];

    public function organization()
    {
        return $this->belongsTo(Organization::class);
    }
}
