<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shift extends Model
{
    use HasFactory;

    protected $fillable = [
        'shift_code',
        'start_time',
        'end_time',
    ];

    /**
     * The employees that belong to the shift.
     * The pivot table (employee_shift) includes additional fields: clock_in, clock_out.
     */
    public function employees()
    {
        return $this->belongsToMany(\App\Models\Employee::class, 'employee_shift')
                    ->withPivot('clock_in', 'clock_out')
                    ->withTimestamps();
    }
}
