<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model
{
    use HasFactory;
    protected $table = 'product_variants'; // ✅ Ensure the correct table name

    protected $fillable = [
        'product_id',
        'variant_id',      // References the variant attribute (e.g., "Color")
        'price',
        'quantity',
        'sku',
        'discount_type',
        'discount_value',
        'quantity_alert',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variant()
    {
        return $this->belongsTo(Variant::class);
    }
}
