<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $fillable = [
        'order_id',
        'product_id',
        'quantity',
        'price',
        'total',
    ];

    // Relationship to the Order
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    // **NEW:** Relationship to the Product
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
