<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'order_number',
        'transaction_id',
        'cashier',
        'status',
        'total_amount',
        'subtotal',
        'tax',
        'shipping',
        'discount',
        'payment_method',
        'payment_details',
        'receipt_path', // Added for PDF receipt path
    ];

    protected $casts = [
        'payment_details' => 'array',
    ];

    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }
}
