<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'role',              // e.g., Employee, Manager, Owner
        'designation_id',    // FK to Designation
        'department_id',     // FK to Department
        'employee_id',
        'email',
        'phone',
        'shift_id',          // FK to Shift
        'status',            // e.g., Probation, Pending, Active, Suspended, Terminated
        'user_id',
        'marital_status',
        'gender',
        'national_id',
        'kra_pin',
        'shif_no',
        'nssf_no',
        'bank_name',
        'account_no',
        'salary',
        'allowances',        // Can store as JSON/text (stringified JSON or CSV)
        'deductions',        // Same as above
        'passport_image'     // Path to the passport image
    ];

    // Relationships

    // Each employee belongs to a User account (for login)
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Each employee belongs to a Department.
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    // Each employee has a Designation.
    public function designation()
    {
        return $this->belongsTo(Designation::class);
    }

    // Each employee is assigned to a Shift.
    public function shift()
    {
        return $this->belongsTo(Shift::class);
    }
}
