<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Designation extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'job_group',
        'salary_range', // This could be stored as a string (e.g., "30000-50000") or as two numeric columns (min and max)
        'benefits',     // A text field that can hold a JSON or comma‐separated list of benefits/allowances
        'deductions'    // A text field for statutory deductions (again, can be JSON or CSV)
    ];

    // If you want to relate a designation to many employees:
    public function employees()
    {
        return $this->hasMany(\App\Models\Employee::class);
    }
}
