<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Employee;

class Department extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        // Other fields...
        'head_id',
    ];

    /**
     * Get the head of the department.
     */
    public function head()
    {
        return $this->belongsTo(Employee::class, 'head_id');
    }
}
