<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Allowance extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
    ];

    /**
     * Define a many-to-many relationship with employees.
     * The pivot table "allowance_employee" stores the specific amount for each employee.
     */
    public function employees()
    {
        return $this->belongsToMany(Employee::class, 'allowance_employee')
                    ->withPivot('amount')
                    ->withTimestamps();
    }
}
