<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckRolePermission
{
    public function handle(Request $request, Closure $next, $role = null, $permission = null)
    {
        $user = Auth::user();

        if (!$user) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthenticated',
            ], 401);
        }

        // Check for role
        if ($role && $user->role->name !== $role) {
            return response()->json([
                'status' => 'error',
                'message' => 'Access denied: Insufficient role',
            ], 403);
        }

        // Check for permission
        if ($permission && !$user->hasPermission($permission)) {
            return response()->json([
                'status' => 'error',
                'message' => 'Access denied: Insufficient permissions',
            ], 403);
        }

        return $next($request);
    }
}
