<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Support\Facades\Log;

class Authenticate extends Middleware
{
    /**
     * Handle unauthenticated requests.
     *
     * @param \Illuminate\Http\Request $request
     * @param array $guards
     * @throws \Illuminate\Http\Exceptions\HttpResponseException
     */
    protected function unauthenticated($request, array $guards)
    {
        Log::debug('Authenticate Middleware: Unauthenticated request.', [
            'url' => $request->url(),
            'guards' => $guards,
        ]);

        // Return JSON response for unauthenticated requests
        throw new \Illuminate\Http\Exceptions\HttpResponseException(
            response()->json([
                'message' => 'Invalid or missing access token',
            ], 401)
        );
    }

    /**
     * Prevent redirection to login for unauthenticated requests.
     *
     * @param \Illuminate\Http\Request $request
     * @return string|null
     */
    protected function redirectTo($request)
    {
        Log::debug('Authenticate Middleware: RedirectTo method called.', [
            'url' => $request->url(),
        ]);

        // Prevent redirection
        return null;
    }
}
