<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Subscription;

class SubscriptionController extends Controller
{
    public function index()
    {
        $subscriptions = Subscription::with('organization')->get();
        return response()->json($subscriptions);
    }

    public function store(Request $request)
    {
        $request->validate([
            'organization_id' => 'required|exists:organizations,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after:start_date',
            'type' => 'required|string|in:monthly,bi-annual,yearly',
            'status' => 'required|string|in:active,expired',
        ]);

        $subscription = Subscription::create($request->all());
        return response()->json(['message' => 'Subscription created successfully', 'subscription' => $subscription], 201);
    }

    public function show($id)
    {
        $subscription = Subscription::with('organization')->find($id);

        if (!$subscription) {
            return response()->json(['message' => 'Subscription not found'], 404);
        }

        return response()->json($subscription);
    }

    public function update(Request $request, $id)
    {
        $subscription = Subscription::find($id);

        if (!$subscription) {
            return response()->json(['message' => 'Subscription not found'], 404);
        }

        $request->validate([
            'start_date' => 'sometimes|date',
            'end_date' => 'sometimes|date|after:start_date',
            'type' => 'sometimes|string|in:monthly,bi-annual,yearly',
            'status' => 'sometimes|string|in:active,expired',
        ]);

        $subscription->update($request->all());
        return response()->json(['message' => 'Subscription updated successfully', 'subscription' => $subscription]);
    }

    public function destroy($id)
    {
        $subscription = Subscription::find($id);

        if (!$subscription) {
            return response()->json(['message' => 'Subscription not found'], 404);
        }

        $subscription->delete();
        return response()->json(['message' => 'Subscription deleted successfully']);
    }
}
