<?php

namespace App\Exceptions;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Throwable;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;

class Handler extends ExceptionHandler
{
    /**
     * Render an exception into an HTTP response.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Throwable $exception
     * @return \Illuminate\Http\JsonResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function render($request, Throwable $exception)
    {
        // Return JSON for all API routes
        if ($request->is('api/*')) {
            $status = 500; // Default status code
            $message = 'An unexpected error occurred'; // Default message

            // Handle specific exception types
            if ($exception instanceof HttpException) {
                $status = $exception->getStatusCode();
                $message = $exception->getMessage();
            } elseif ($exception instanceof ModelNotFoundException) {
                $status = 404;
                $message = 'Resource not found';
            } elseif ($exception instanceof AuthenticationException) {
                $status = 401;
                $message = 'Unauthenticated';
            } elseif ($exception instanceof ValidationException) {
                $status = 422;
                $message = $exception->errors();
            }

            return response()->json([
                'status' => 'error',
                'message' => $message,
                'error_code' => $status,
            ], $status);
        }

        // Default behavior for non-API routes
        return parent::render($request, $exception);
    }

    /**
     * Handle unauthenticated requests.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Illuminate\Auth\AuthenticationException $exception
     * @return \Illuminate\Http\JsonResponse|\Symfony\Component\HttpFoundation\Response
     */
    protected function unauthenticated($request, AuthenticationException $exception)
    {
        if ($request->is('api/*')) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthenticated',
                'error_code' => 401,
            ], 401);
        }

        return parent::unauthenticated($request, $exception);
    }

    protected function invalidJson($request, ValidationException $exception)
{
    return response()->json([
        'status' => 'error',
        'message' => 'Validation failed',
        'errors' => $exception->errors(),
    ], $exception->status);
}

}
